/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn;

import OreSpawn.OreSpawnMain;
import dangerzone.Chunk;
import dangerzone.Ores;
import dangerzone.World;
import dangerzone.biomes.Biome;
import dangerzone.biomes.RuggedBiome;
import dangerzone.blocks.Blocks;

public class KrakenKingBiome
extends RuggedBiome {
    public KrakenKingBiome(String n) {
        super(n);
        this.hilliness = 5.5f;
        this.roughness = 0.5f;
        this.should_add_waterplants = true;
        this.should_add_caves = false;
    }

    public void generate(World w, int d, Chunk c, int cx, int cz, int[][] dirtheight, int[][] stoneheight, int[][] lm3) {
        int waterlevel = 70;
        int j = 0;
        while (j < 250) {
            int i = 0;
            while (i < 16) {
                int k = 0;
                while (k < 16) {
                    if (j < stoneheight[i][k]) {
                        if (j < stoneheight[i][k] / 2) {
                            c.setblock(i, j, k, Blocks.stone.blockID);
                        } else {
                            c.setblock(i, j, k, Blocks.sand.blockID);
                        }
                    } else if (j <= waterlevel) {
                        c.setblock(i, j, k, Blocks.waterstatic.blockID);
                    } else {
                        if (j < dirtheight[i][k] - 1 && c.getblock(i, j - 1, k) != 0 && c.getblock(i, j - 1, k) != Blocks.waterstatic.blockID && j < 150) {
                            c.setblock(i, j, k, Blocks.dirt.blockID);
                        }
                        if (j == dirtheight[i][k] - 1 && c.getblock(i, j - 1, k) == Blocks.dirt.blockID && j < 130) {
                            c.setblock(i, j, k, Blocks.grassblock.blockID);
                            c.setblockmeta(i, j, k, w.rand.nextInt(4) << 12);
                        }
                    }
                    if (j == 0) {
                        c.setblock(i, j, k, Blocks.stopblock.blockID);
                    }
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        Ores.generate((World)w, (int)d, (Biome)this, (Chunk)c, (int)cx, (int)cz);
    }

    public void decorate(World world, int d, Chunk c, int chunkx, int chunkz) {
        int modchunkx = chunkx % 128;
        int modchunkz = chunkz % 128;
        if (modchunkx == 29 && modchunkz == 29) {
            int i = 70;
            while (i < 80) {
                if (world.getblock(d, chunkx << 4, i, chunkz << 4) == 0) break;
                ++i;
            }
            OreSpawnMain.MyDungeons.makeKrakenKingCastle(world, d, chunkx << 4, i, chunkz << 4);
        }
        if (modchunkx >= 25 && modchunkx <= 33 && modchunkz >= 25 && modchunkz <= 33) {
            this.tr.addGrass(world, d, chunkx << 4, chunkz << 4, c);
            return;
        }
        if (world.rand.nextBoolean()) {
            if (world.rand.nextBoolean()) {
                this.tr.addTallPineTrees(world, d, chunkx << 4, chunkz << 4);
            } else if (world.rand.nextBoolean()) {
                this.tr.addTallWillowTrees(world, d, chunkx << 4, chunkz << 4);
            } else {
                this.tr.addForestTrees(world, d, chunkx << 4, chunkz << 4);
            }
        }
        this.tr.addGrass(world, d, chunkx << 4, chunkz << 4, c);
    }
}

